function saveDeviceSettings() {
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/network.cgi?";
    warningMessage = "";

    cgiParam.CameraName = $("#cameraIdInput").val();
    cgiParam.Location = $("#locationInput").val();
    if (cgiParam.CameraName.length == 0) {
        warningMessage += getMessageNull("Camera ID");
    }
    if (cgiParam.Location.length == 0) {
        warningMessage += getMessageNull("Location");
    }
    if (warningMessage.length > 0) {
        showMessageModal("Warning", warningMessage, null);
        return;
    }
    AddParameter("CameraName", cgiParam.CameraName);
    AddParameter("Location", cgiParam.Location);

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Device Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            console.log("Device settings saved to " + cameraSettings.CameraName);
            reloadDevice();
            UnblockUIforPage();
        }
    });
}

function reloadDevice() {
    openDevice();
}

function openDevice() {
    $("#DivMainPage").load("./page/device.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;


        $.ajax({
            url: "/command/inquiry.cgi?inqjs=main&inqjs=network&inqjs=system",
            type: "GET",
            error: function (xhr) {
                console.log("Get system info fail");
            },
            success: function (response) {
                var pcDateNow = {};
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                document.title = cameraSettings.CameraName;
                $("#cameraIdInput").val(cameraSettings.CameraName);
                $("#locationInput").val(cameraSettings.Location);

                $("#applyButton").on('click', saveDeviceSettings);
                $("#cancelButton").on('click', reloadDevice);
            }
        });
    });
}
